Imports extract_invoice.DynaPDF

Module Module1

   ' Error callback function.
   ' If the function name should not appear at the beginning of the error message then set
   ' the flag emNoFuncNames (pdf.SetErrorMode(TErrMode.emNoFuncNames)).
   Private Function PDFError(ByVal Data As IntPtr, ByVal ErrCode As Integer, ByVal ErrMessage As IntPtr, ByVal ErrType As Integer) As Integer
      Console.Write("{0} + chr(10)", System.Runtime.InteropServices.Marshal.PtrToStringAnsi(ErrMessage))
      Return 0 ' We try to continue if an error occurrs. Any other return value breaks processing.
   End Function

   ' Helper function
   Private Function GetFileBuf(ByVal FileName As String) As Byte()
      Dim retval As Byte()
      Dim f As System.IO.FileStream = New System.IO.FileStream(FileName, System.IO.FileMode.Open)

      ReDim retval(f.Length - 1)
      f.Read(retval, 0, f.Length)
      f.Close()
      Return retval
   End Function

   Private Function HaveEInvoice(ByVal PDF As CPDF, ByVal InFileName As String) As Boolean
      Dim retval As Boolean
      Dim info As TPDFVersionInfo = New TPDFVersionInfo()

      PDF.CreateNewPDF(Nothing)
      ' We need the document info or metadata and embedded files only
      PDF.SetImportFlags(TImportFlags.ifDocInfo Or TImportFlags.ifEmbeddedFiles)
      PDF.SetImportFlags2(TImportFlags2.if2UseProxy)
      If PDF.OpenImportFile(InFileName, TPwdType.ptOpen, Nothing) < 0 Then GoTo finish

      ' Other stuff can be ignored
      PDF.ImportCatalogObjects()

      If Not PDF.GetPDFVersionEx(info) Then GoTo finish

      If info.PDFAVersion = 3 And info.FXDocName <> Nothing Then
         Dim ef As Integer
         Dim fs As TPDFFileSpec = New TPDFFileSpec()
         ef = PDF.FindEmbeddedFile(info.FXDocName)
         If ef < 0 Then
            Console.ForegroundColor = ConsoleColor.Red
            Console.Write("Invoice {0} not found!\n", info.FXDocName)
            GoTo finish
         End If
         If ef <> 0 Then
            Console.ForegroundColor = ConsoleColor.Yellow
            Console.Write("Warning: The invoice should be the first file attachment. This might cause unnecessary problems.\n")
         End If
         retval = PDF.GetEmbeddedFile(ef, fs, True) And fs.Buffer.Length > 0
      End If
finish:
      PDF.FreePDF()
      Return retval
   End Function

      Private Function CreateInvoice(ByVal PDF As CPDF, ByVal FacturX As Boolean, ByVal InvoiceName As String, ByVal OutFile As String) As Boolean
         Dim ef As Integer
         Dim retval As Boolean
         ' The output file is opened later
         PDF.CreateNewPDF(Nothing)

         ' Set the license key here if you have one
         ' PDF.SetLicenseKey("")

         ' We assume that the PDF invoice is already a valid PDF/A 3 file in this example.

         PDF.SetImportFlags(TImportFlags.ifImportAsPage Or TImportFlags.ifImportAll)
         If PDF.OpenImportFile("../../../../test_files/test_invoice.pdf", TPwdType.ptOpen, Nothing) < 0 Then GoTo finish

         PDF.ImportPDFFile(1, 1.0, 1.0)

         ' The test invoice has the file name factur-x.xml. This is the right name for FacturX and ZUGFeRD output.
         ' However, for XRechnung the file name must be xrechnung.xml. So, we must be able to change the file
         ' name to get this example working. We could rename the input file but the usage of AttachFileEx() is probably
         ' more elegant.

         ' It is not of interest here whether the xml file is a valid ZUGFeRD or XRechnung. This example shows how the
         ' PDF container must be created and how to extract the xml invoice from an arbitrary e-invoice.

         Dim buffer As Byte() = GetFileBuf("../../../../test_files/factur-x.xml")

         ' The invoice name of a XRechnung might be xrechnung.xml or factur-x.xml. Both names must work with DynaPDF.
         ef = PDF.AttachFileEx(buffer, InvoiceName, "EN 19631 compliant invoice", False)

         buffer = Nothing

         If FacturX Then
            ' Note that ZUGFeRD 2.1 or higher and FacturX is identically defined in PDF. Therefore, both formats share
            ' the same version constants. Note also that the profiles Minimum, Basic, and Basic WL are not fully EN 16931
            ' compliant, and hence cannot be used to create e-invoices.
            PDF.SetPDFVersion(TPDFVersion.pvFacturX_Comfort)
            PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arAlternative, ef)
         Else
            PDF.SetPDFVersion(TPDFVersion.pvFacturX_XRechnung)
            PDF.AssociateEmbFile(TAFDestObject.adCatalog, -1, TAFRelationship.arSource, ef)
         End If

         ' No fatal error occurred?
         If PDF.HaveOpenDoc() Then
            ' OK, now we can open the output file.
            If Not PDF.OpenOutputFile(OutFile) Then GoTo finish
            retval = PDF.CloseFile()
         End If

finish:
         PDF.FreePDF()
         Return retval
      End Function

   Sub Main()
      Try
         Dim pdf As CPDF = New CPDF()
         ' Error messages and warnings are passed to the callback function.
         pdf.SetOnErrorProc(AddressOf PDFError)

         Dim outFile As String = System.IO.Directory.GetCurrentDirectory() + "\out.pdf"

         ' Test cases:
         ' - ZUGFeRD or FacturX
         ' - XRechnung -> The invoice name must be xrechnung.xml
         If Not CreateInvoice(pdf, True, "factur-x.xml", outFile) Or Not HaveEInvoice(pdf, outFile) _
         Or Not CreateInvoice(pdf, False, "xrechnung.xml", outFile) Or Not HaveEInvoice(pdf, outFile) Then
            Console.ForegroundColor = ConsoleColor.Red
            Console.Write("XML Invoice not found!")
         Else
            Console.ForegroundColor = ConsoleColor.Green
            Console.Write("All tests passed!")
         End If
      Catch e As Exception
         Console.Write(e.Message + Chr(10))
      End Try
      Console.Read()
   End Sub

End Module
